<?php
// Database connection
$servername = "localhost";
$username = "kscrm";
$password = "KS#crm@2025";
$dbname = "kscrm_kitchenstudio";

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Start transaction
    $conn->beginTransaction();
    
    // Process form submission
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Get the number of requirement rows submitted
        $requirementCount = count($_POST['designer']);
        
        // Prepare the insert statement for requirements
        $stmt = $conn->prepare("INSERT INTO technician_visit_site_photo 
                               (name, photo_type, attachments, created_at) 
                               VALUES (:name, :photo_type, :attachments, NOW())");
        
        // Process each requirement row
        for ($i = 0; $i < $requirementCount; $i++) {
            $name = $_POST['designer'][$i] ?? '';
            $photoType = $_POST['type_photo'][$i] ?? '';
            
            // Handle file uploads
            $attachments = [];
            if (isset($_FILES['attachment']['name'][$i])) {
                $fileCount = count($_FILES['attachment']['name'][$i]);
                
                for ($j = 0; $j < $fileCount; $j++) {
                    if ($_FILES['attachment']['error'][$i][$j] === UPLOAD_ERR_OK) {
                        $targetDir = "uploads/";
                        $fileName = basename($_FILES['attachment']['name'][$i][$j]);
                        $targetFile = $targetDir . uniqid() . '_' . $fileName;
                        
                        // Validate and move uploaded file
                        if (move_uploaded_file($_FILES['attachment']['tmp_name'][$i][$j], $targetFile)) {
                            $attachments[] = $targetFile;
                        }
                    }
                }
            }
            
            // Convert attachments array to string (JSON)
            $attachmentsJson = json_encode($attachments);
            
            // Bind parameters and execute
            $stmt->bindParam(':name', $name);
            $stmt->bindParam(':photo_type', $photoType);
            $stmt->bindParam(':attachments', $attachmentsJson);
            $stmt->execute();
        }
        
        // Commit transaction
        $conn->commit();
        
        echo "Requirements submitted successfully!";
    }
} catch(PDOException $e) {
    // Rollback transaction on error
    if (isset($conn)) {
        $conn->rollBack();
    }
    echo "Error: " . $e->getMessage();
}

// Close connection
$conn = null;
?>