<?php 
header('Content-Type: application/json');
include 'connection.php';
session_start();

if (!isset($_SESSION['is_logged_in'])) {
    echo json_encode(['success' => false, 'error' => 'Not logged in']);
    exit;
}

$lead_id = $_REQUEST['lead_id'] ?? '';
$reminder_date = $_POST['next_reminder_date'] ?? '';
$enquiry_priority = $_POST['enquiry_priority'] ?? '';
$reminder_note = $_POST['reminder_notes'] ?? '';


// Prepare and execute the update
$stmt = $conn->prepare("UPDATE customer_leads SET nxt_remind_time = ?, enquiry_priority = ?, reminder_notes = ? WHERE lead_id = ?");
if (!$stmt) {
    die("Prepare failed: " . $conn->error);
}

$stmt->bind_param("sssi", $reminder_date, $enquiry_priority, $reminder_note, $lead_id);

if ($stmt->execute()) {
    header("Location: view_all_enquiry.php?inserted=1");
    exit;
} else {
    echo "Error updating reminder: " . $stmt->error;
}

