<?php
ob_start();
include 'connection.php';
session_start();

if (!isset($_SESSION['is_logged_in'])) {
    header("Location:login.php");
    die();
}

$lead_id = $_REQUEST['lead_id'];
$query = "SELECT * FROM customer_leads WHERE lead_id = '$lead_id'";
$result = mysqli_query($conn, $query);
$data = mysqli_fetch_assoc($result);

function formatMulti($val) {
    return implode(', ', json_decode($val, true) ?? explode(',', $val));
}
function getSegmentNames($conn, $ids) {
    $idArray = array_filter(explode(',', $ids));
    if (empty($idArray)) return '';

    $escapedIds = array_map('intval', $idArray); // Secure
    $in = implode(',', $escapedIds);

    $query = "SELECT sid, segment FROM segment WHERE sid IN ($in)";
    $result = mysqli_query($conn, $query);

    $segment = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $segment[] = $row['segment'];
    }

    return implode(', ', $segment);
}
function getArchitectFirmName($conn, $firmId) {
    $firmId = intval($firmId);
    if (!$firmId) return '';

    $query = "SELECT firm_name FROM architectfirm_master WHERE firm_id = $firmId";
    $result = mysqli_query($conn, $query);

    if ($row = mysqli_fetch_assoc($result)) {
        return $row['firm_name'];
    }

    return '';
}
function getBuilderName($conn, $builderId) {
    $builderId = intval($builderId);
    $result = mysqli_query($conn, "SELECT builder_name FROM buildersites_master WHERE builder_id = $builderId");
    return $result && $row = mysqli_fetch_assoc($result) ? $row['builder_name'] : '';
}

function getAllUsersMap($conn) {
    $map = [];
    $result = mysqli_query($conn, "SELECT user_id, name FROM mst_users");
    while ($row = mysqli_fetch_assoc($result)) {
        $map[$row['user_id']] = $row['name'];
    }
    return $map;
}
$usersMap = getAllUsersMap($conn);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Customer Lead Full View</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            font-size: 14px;
            margin: 0;
            background: #eaeaea;
        }

        .print-container {
            max-width: 1100px;
            margin: 40px auto;
            background: #fff;
            padding: 40px 50px;
            border-radius: 12px;
            box-shadow: 0 0 25px rgba(0,0,0,0.07);
        }

        .header {
            text-align: center;
            margin-bottom: 40px;
        }

        .header h1 {
            margin: 0;
            font-size: 28px;
            color: #8a2c49;
        }

        .header p {
            color: #777;
            font-size: 13px;
        }

        .section {
            margin-bottom: 30px;
        }

        .section h2 {
            background: linear-gradient(to right, #8a2c49, #b54a63);
            color: white;
            padding: 12px 20px;
            border-radius: 8px;
            font-size: 18px;
            margin-bottom: 20px;
        }

        .row {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
        }

        .col {
            flex: 1 0 47%;
            background: #f8f8f8;
            padding: 12px 16px;
            border-radius: 8px;
            border-left: 5px solid #8a2c49;
        }

        label {
            font-weight: bold;
            color: #444;
            display: block;
            margin-bottom: 4px;
        }

        .value {
            color: #333;
            font-size: 14px;
            white-space: pre-wrap;
        }

        .noprint {
            text-align: right;
            margin: 20px auto;
            max-width: 1100px;
        }

        .noprint button {
            background: #8a2c49;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 6px;
            font-size: 14px;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        .noprint button:hover {
            background: #a03558;
        }

        @media print {
            .noprint {
                display: none;
            }

            .print-container {
                box-shadow: none;
                border-radius: 0;
                padding: 0;
                margin: 0;
            }

            body {
                background: white;
            }
        }
    </style>
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

</head>
<body>
<div class="noprint" style="display: flex; justify-content: space-between; align-items: center; max-width: 1100px; margin: 20px auto;">
    <a href="index.php" style="text-decoration: none;">
        <button style="background: #6c757d; color: white; padding: 10px 20px; border: none; border-radius: 6px; font-size: 14px; cursor: pointer;">
            <i class="fas fa-arrow-left"></i> Back to Dashboard
        </button>
    </a>
    <button onclick="window.print()" style="background: #8a2c49; color: white; padding: 10px 20px; border: none; border-radius: 6px; font-size: 14px; cursor: pointer;">
        <i class="fas fa-print"></i> Print
    </button>
</div>

<div class="print-container">
    <div class="header">
        <h1>Customer Lead - Full Details</h1>
        <p><?= date('F j, Y') ?></p>
    </div>

    <div class="section">
        <h2>Lead Information</h2>
        <div class="row">
             <?php
           foreach ($data as $key => $value) {
    $label = ucwords(str_replace('_', ' ', $key));

    switch ($key) {
        case 'segments':
            $displayValue = getSegmentNames($conn, $value);
            break;
        case 'architect_firm_id':
            $displayValue = getArchitectFirmName($conn, $value);
            break;
        case 'builder_id':
            $displayValue = getBuilderName($conn, $value);
            break;
        case 'designer_id':
        case 'entry_by':
        case 'user_id':
        case 'assign_to':
        case 'technision_id':
            $displayValue = isset($usersMap[$value]) ? $usersMap[$value] : 'N/A';
            break;
        default:
            $displayValue = nl2br(htmlspecialchars($value));
    }

    echo "<div class='col'><label>$label:</label><div class='value'>$displayValue</div></div>";
}


            ?>
        </div>
    </div>
</div>
</body>
</html>
