<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Login | Kitchen Studio CRM</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" rel="stylesheet">
  <style>
    html, body {
      height: 100%;
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
    }

    .swiper {
      height: 100vh;
      position: absolute;
      width: 100%;
      z-index: -1;
    }

    .swiper-slide {
      background-size: cover;
      background-position: center;
    }

    .overlay-content {
      position: relative;
      z-index: 1;
      background-color: rgba(0, 0, 0, 0.6);
      padding: 3rem;
      border-radius: 12px;
      max-width: 400px;
      width: 100%;
      color: white;
    }

    .centered-container {
      height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .form-control, .btn {
      border-radius: 8px;
    }
  </style>
</head>
<body>

  <!-- Swiper Background -->
  <div class="swiper mySwiper">
    <div class="swiper-wrapper">
      <div class="swiper-slide" style="background-image: url('assets/img/bg/authentication-bg-01.png');"></div>
      <div class="swiper-slide" style="background-image: url('assets/img/bg/authentication-bg-02.png');"></div>
      <div class="swiper-slide" style="background-image: url('assets/img/bg/authentication-bg-03.png');"></div>
    </div>
  </div>

  <!-- Login Form Overlay -->
  <div class="centered-container">
    <div class="overlay-content">
      <div class="text-center mb-4">
        <img src="assets/img/logo.jpg" alt="Logo" class="img-fluid" width="150">
        <h3 class="mt-3">Welcome Back</h3>
      </div>
      <form action="check.php" method="post">
        <div class="mb-3">
          <label>Username</label>
          <input type="text" class="form-control" name="username">
        </div>
        <div class="mb-3">
          <label>Password</label>
          <input type="password" class="form-control" name="password">
        </div>
        <div class="mb-3 d-flex justify-content-end">
          <a href="forgot-password.html" class="text-light">Forgot Password?</a>
        </div>
        <button type="submit" class="btn btn-light w-100">Log In</button>
      </form>
      <p class="text-center mt-4 text-light small">&copy; 2025 Kitchen Studio</p>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.js"></script>
  <script>
    const swiper = new Swiper('.mySwiper', {
      effect: 'fade',
      loop: true,
      autoplay: {
        delay: 3000,
        disableOnInteraction: false,
      },
      speed: 1500,
      fadeEffect: {
        crossFade: true
      }
    });
  </script>

</body>
</html>
