<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Login | Kitchen Studio CRM</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" rel="stylesheet">

  <style>
    body, html {
      height: 100%;
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
    }

    .login-container {
      display: flex;
      height: 100vh;
      overflow: hidden;
    }

    .left-side {
      width: 55%;
      position: relative;
    }

    .swiper {
      height: 100%;
    }

    .swiper-slide {
      background-size: cover;
      background-position: center;
    }

    .left-overlay {
      position: absolute;
      top: 0;
      left: 0;
      height: 100%;
      width: 100%;
      background: rgba(0, 0, 0, 0.45);
      z-index: 1;
      display: flex;
      justify-content: center;
      align-items: center;
      color: #fff;
      text-align: center;
      padding: 2rem;
    }

    .left-overlay h1 {
      font-size: 2.8rem;
      font-weight: bold;
      animation: fadeInUp 1.2s ease-out;
    }

    .right-side {
      width: 45%;
      background: #ffffff;
      display: flex;
      justify-content: center;
      align-items: center;
      padding: 2rem;
    }

    .login-form {
      width: 100%;
      max-width: 360px;
      animation: fadeIn 1.4s ease;
    }

    .login-form h2 {
      font-weight: 600;
      margin-bottom: 1.5rem;
    }

    .form-control:focus {
      box-shadow: none;
      border-color: #000;
    }

    .btn-custom {
      background-color: #000;
      color: #fff;
      font-weight: 500;
      border-radius: 8px;
    }

    .btn-custom:hover {
      background-color: #333;
    }

    @keyframes fadeInUp {
      from { opacity: 0; transform: translateY(30px); }
      to { opacity: 1; transform: translateY(0); }
    }

    @keyframes fadeIn {
      from { opacity: 0; }
      to { opacity: 1; }
    }

    @media (max-width: 768px) {
      .login-container {
        flex-direction: column;
      }
      .left-side, .right-side {
        width: 100%;
        height: 50vh;
      }
      .left-overlay h1 {
        font-size: 1.8rem;
      }
    }
  </style>
</head>
<body>

  <div class="login-container">
    
    <!-- Left: Background Image Slideshow -->
    <div class="left-side">
      <div class="swiper mySwiper">
        <div class="swiper-wrapper">
          <div class="swiper-slide" style="background-image: url('assets/img/bg/login2bg_01.jpeg');"></div>
          <div class="swiper-slide" style="background-image: url('assets/img/bg/login2bg_02.jpeg');"></div>
          <div class="swiper-slide" style="background-image: url('assets/img/bg/login2bg_03.jpeg');"></div>
        </div>
      </div>
      <div class="left-overlay">
        <h1>Welcome to Kitchen Studio</h1>
      </div>
    </div>

    <!-- Right: Login Form -->
    <div class="right-side">
      <div class="login-form">
        <div class="text-center mb-4">
          <img src="assets/img/logo.jpg" alt="Logo" class="img-fluid">
        </div>
        
        <form action="check.php" method="post">
          <div class="mb-3">
            <label class="form-label">Username</label>
            <input type="text" class="form-control" name="username" placeholder="Enter username">
          </div>
          <div class="mb-3">
            <label class="form-label">Password</label>
            <input type="password" class="form-control" name="password" placeholder="Enter password">
          </div>
          <div class="mb-3 text-end">
            <a href="forgot-password.html" class="text-decoration-none text-muted">Forgot Password?</a>
          </div>
          <div class="mb-3 d-grid">
            <button type="submit" class="btn btn-custom">Log In</button>
          </div>
        </form>
        <p class="text-center text-muted mt-4">&copy; 2025 Kitchen Studio</p>
      </div>
    </div>

  </div>

  <script src="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.js"></script>
  <script>
    const swiper = new Swiper(".mySwiper", {
      effect: "fade",
      loop: true,
      autoplay: {
        delay: 4000,
        disableOnInteraction: false,
      },
      fadeEffect: {
        crossFade: true
      },
    });
  </script>

</body>
</html>
