<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Login | Kitchen Studio CRM</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body, html {
      height: 100%;
      margin: 0;
    }

    /* Background Image with Overlay Opacity */
    body::before {
      content: '';
      position: fixed;
      top: 0; left: 0;
      width: 100%; height: 100%;
      background: url('assets/img/bg/login1bg_01.jpeg') no-repeat center center/cover;
      opacity: 0.3; /* Image opacity */
      z-index: -1;
    }

    .login-card {
      max-width: 600px; /* Increased width */
      width: 90%;
      padding: 2.5rem;
      border-radius: 12px;
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
      background-color: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(4px);
    }

    .login-card .form-control:focus {
      box-shadow: none;
      border-color: #0d6efd;
    }

    a {
      text-decoration: none;
      font-size: 0.9rem;
    }

    @media (max-width: 576px) {
      .login-card {
        padding: 2rem;
      }
    }
  </style>
</head>
<body>

  <div class="d-flex justify-content-center align-items-center vh-100">
    <div class="login-card text-center">
      <div class="mb-4">
        <img src="assets/img/logo.jpg" alt="Logo" class="img-fluid" width="130">
        <h3 class="mt-3">Sign In</h3>
      </div>
      <form action="check.php" method="post">
        <div class="mb-3 text-start">
          <label class="form-label">Username</label>
          <input type="text" name="username" class="form-control" required>
        </div>
        <div class="mb-3 text-start">
          <label class="form-label">Password</label>
          <input type="password" name="password" class="form-control" required>
        </div>
        <div class="d-flex justify-content-between mb-3">
          <a href="forgot-password.html" class="text-muted">Forgot Password?</a>
        </div>
        <button class="btn btn-primary w-100" type="submit">Log In</button>
      </form>
      <p class="text-center mt-4 text-muted small">&copy; 2025 Kitchen Studio</p>
    </div>
  </div>

</body>
</html>
