<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Login | Kitchen Studio CRM</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" rel="stylesheet">
<style>

    html, body {

      height: 100%;

      margin: 0;

      font-family: 'Segoe UI', sans-serif;

    }



    .swiper {

      height: 100vh;

      position: absolute;

      width: 100%;

      z-index: -1;

    }



    .swiper-slide {

      background-size: cover;

      background-position: center;

    }



    .overlay {

      position: absolute;

      width: 100%;

      height: 100%;

      background: rgba(0, 0, 0, 0.5); /* subtle dark overlay for readability */

      z-index: 0;

    }



    .glass-card {

      background: rgba(255, 255, 255, 0.15);

      border-radius: 16px;

      backdrop-filter: blur(14px);

      -webkit-backdrop-filter: blur(14px);

      box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);

      border: 1px solid rgba(255, 255, 255, 0.2);

      padding: 2.5rem;

      color: white;

      max-width: 420px;

      width: 100%;

      z-index: 1;

      animation: fadeIn 1.2s ease-in-out;

    }



    @keyframes fadeIn {

      from { opacity: 0; transform: translateY(20px); }

      to { opacity: 1; transform: translateY(0); }

    }



    .form-control {

      background: rgba(255, 255, 255, 0.2);

      border: none;

      color: #fff;

    }



    .form-control::placeholder {

      color: #eee;

    }



    .btn-glow {

      background: #fff;

      color: #000;

      font-weight: bold;

      border-radius: 8px;

      transition: all 0.3s ease;

    }



    .btn-glow:hover {

      box-shadow: 0 0 18px rgba(255, 255, 255, 0.8);

    }



    .footer {

      font-size: 0.85rem;

      opacity: 0.7;

      margin-top: 1rem;

      color: #eee;

    }



    .logo {

      width: 150px;

    }

  </style>
</head>
<body>
<!-- Swiper Background Slider -->
<div class="swiper mySwiper">
<div class="swiper-wrapper">
<div class="swiper-slide" style="background-image: url('assets/img/bg/login5bg_01.jpeg');"></div>
<div class="swiper-slide" style="background-image: url('assets/img/bg/login5bg_02.jpeg');"></div>
<div class="swiper-slide" style="background-image: url('assets/img/bg/login5bg_03.jpeg');"></div>
</div>
</div>
<!-- Dark Overlay -->
<div class="overlay"></div>
<!-- Centered Glass Form -->
<div class="d-flex justify-content-center align-items-center vh-100 position-relative">
<div class="glass-card text-center"> <img src="assets/img/logo.jpg" alt="Logo" class="logo mb-3">
<h3 class="mb-4">Welcome Back</h3>
<form action="check.php" method="post">
<div class="mb-3 text-start">
<label class="form-label">Username</label>
<input type="text" class="form-control" name="username" placeholder="Enter username" required>
</div>
<div class="mb-3 text-start">
<label class="form-label">Password</label>
<input type="password" class="form-control" name="password" placeholder="Enter password" required>
</div>
<div class="d-flex justify-content-end mb-3"> <!--<a href="forgot-password.html" class="text-light">Forgot Password?</a>--> </div>
<button type="submit" class="btn btn-glow w-100">Log In</button>
</form>
<div class="footer"> &copy; 2025 Kitchen Studio </div>
</div>
</div>
<script src="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.js"></script>
<script>

    const swiper = new Swiper('.mySwiper', {

      effect: 'fade',

      loop: true,

      autoplay: {

        delay: 3000,

        disableOnInteraction: false,

      },

      speed: 1200,

      fadeEffect: {

        crossFade: true

      }

    });

  </script>
</body>
</html>
