<?php
session_start();
include 'connection.php';
date_default_timezone_set('Asia/Calcutta');

// Already created once?
if (isset($_SESSION['order_id'])) {
    echo json_encode(['status' => 'exists', 'order_id' => $_SESSION['order_id']]);
    exit;
}

// Get input (from AJAX)
$order_no        = $_POST['order_no'] ?? '';
$order_date      = $_POST['order_date'] ?? date('Y-m-d');
$customer_name   = $_POST['customer_name'] ?? '';
$order_type      = $_POST['order_type'] ?? '';
$entry_by        = $_SESSION['user_id'] ?? 0;
$lead_id         = $_POST['lead_id'] ?? 0;
$lead_no         = $_POST['lead_no'] ?? '';
$ref_date        = $_POST['ref_date'] ?? '';
$reference_no    = $_POST['reference_no'] ?? '';
$call_follow_up_id = $_POST['call_follow_up_id'] ?? 0;

$qryOrder = "INSERT INTO order_form (
    order_no, order_date, customer_name, order_type,
    entry_by, entry_date, entry_time,
    lead_no, lead_id, call_follow_up_id, reference_no, ref_date
) VALUES (
    ?, ?, ?, ?, ?, CURDATE(), CURTIME(), ?, ?, ?, ?, ?
)";
$stmt = $conn->prepare($qryOrder);
$stmt->bind_param(
    "ssssisiisss",
    $order_no, $order_date, $customer_name, $order_type,
    $entry_by, $lead_no, $lead_id, $call_follow_up_id, $reference_no, $ref_date
);

if ($stmt->execute()) {
    $order_id = $conn->insert_id;
    $_SESSION['order_id'] = $order_id;
    echo json_encode(['status' => 'created', 'order_id' => $order_id]);
} else {
    echo json_encode(['status' => 'error', 'message' => $stmt->error]);
}
$stmt->close();
?>