const canvas = document.getElementById("fireworksCanvas");
const ctx = canvas.getContext("2d");
canvas.width = window.innerWidth;
canvas.height = window.innerHeight;

function createFirework(x, y) {
  const particles = [];
  for (let i = 0; i < 100; i++) {
    particles.push({
      x,
      y,
      radius: Math.random() * 3 + 1,
      dx: (Math.random() - 0.5) * 10,
      dy: (Math.random() - 0.5) * 10,
      alpha: 1,
      color: `hsl(${Math.random() * 360}, 100%, 50%)`
    });
  }

  let frame = 0;
  function animate() {
    frame++;
    ctx.fillStyle = "rgba(0, 0, 0, 0.1)";
    ctx.fillRect(0, 0, canvas.width, canvas.height);
    particles.forEach(p => {
      p.x += p.dx;
      p.y += p.dy;
      p.alpha -= 0.01;
      ctx.beginPath();
      ctx.arc(p.x, p.y, p.radius, 0, Math.PI * 2);
      ctx.fillStyle = `rgba(${hexToRgb(p.color)},${p.alpha})`;
      ctx.fill();
    });

    if (frame < 100) requestAnimationFrame(animate);
  }

  animate();
}

function hexToRgb(hsl) {
  const canvas = document.createElement("canvas");
  const ctx = canvas.getContext("2d");
  ctx.fillStyle = hsl;
  return ctx.fillStyle.match(/\d+/g).join(",");
}

// Simulate success event
setTimeout(() => {
  document.getElementById("message").innerText = "Data Inserted Successfully!";
  createFirework(window.innerWidth / 2, window.innerHeight / 2);
}, 500); // Adjust as needed
